local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end

function getFloatingYModifier(self)
	return math.sin(GetTime()/(350.0+self.Width))*(15.5+self.Height/10)-self.TweakY
end

function SwitchDirection(self)
	if self.Direction == 0 then
		self.Direction = 1
	else
		self.Direction = 0
	end
	Look(self)
end

function TurnRight(self)
	self.Direction = 1
	Look(self)
end

function TurnLeft(self)
	self.Direction = 0
	Look(self)
end

function Look(self)
	if self.Direction == 0 then
		self.RutharEye.DrawFlags.Mirror = false
	else
		self.RutharEye.DrawFlags.Mirror = true
	end
end

function isLookingAtClaw(self)
	local claw = GetClaw()
	--if math.abs(self.X - claw.X) <= 64 then -- spot when player is really close
	--	return true
	--end
	if self.X < claw.X then
		if self.Direction == 1 then
			return true
		else
			return false
		end
	else
		if self.Direction == 0 then
			return true
		else
			return false
		end
	end
end

function getDistanceFromClaw(self)
	local claw = GetClaw()
	return math.abs(self.X - claw.X)
end

function getFrontDistance(self)
	if self.Direction == 1 then
		return self.XMax - self.X
	elseif self.Direction == 0 then
		return self.X - self.XMin
	end
end

function getBackDistance(self)
	if self.Direction == 1 then
		return self.X - self.XMin
	elseif self.Direction == 0 then
		return self.XMax - self.X
	end
end

function CalcMaxDistance(self, dir)
	if dir == 0 then
		return self.X - self.XMin
	else
		return self.XMax - self.X
	end
end

function ClawInLOS(self)
	--TextOut(self.sensorLFlag .. ", " .. self.sensorRFlag)
	if _CurrentPowerup[0] == 9911 then --9917
		return false
	elseif self.sensorLFlag == 1 and self.sensorRFlag == 1 then
		local claw = GetClaw()
		--TextOut(self.rangeL .. ", " .. claw.X .. ", " .. self.rangeR)
		--AttackRange = 64 -- Zealot's attack range for purpose of aggro
		local yrange = 168
		if self.Speed == 3 and self.Flags.Safe == false then
			yrange = 256 - self.SpeedY
		end
		if claw.Y > self.Y - yrange and claw.Y < self.Y - 32 and 
			claw.X > self.rangeL and claw.X < self.rangeR and
			claw.X > self.XMin - self.AttackRange and claw.X < self.XMax + self.AttackRange then
			--TextOut(claw.X - self.X)
			if not isLookingAtClaw(self) then
				SwitchDirection(self)
				Look(self)
			end
			return true
		end
		--TextOut(claw.Y - self.Y)
		--if claw.Y > self.Y - 168 and claw.Y < self.Y - 32 and
			--claw.X > self.X - self.AttackRange and claw.X < self.X + self.AttackRange and
			--isLookingAtClaw(self) then
			--
			--return true
		--end
	end
	return false
end

function main(self)
	
	if self.State == 0 then
		if self.XMin == 0 then
			self.XMin = self.X
		end
		if self.XMax == 0 then
			self.XMax = self.X
		end
		if self.X < self.XMin then
			self.X = self.XMin
		end
		if self.X > self.XMax then
			self.X = self.XMax
		end
		self.MoveRect = {0,0,2,2}
		if self.Smarts == 0 then
			self:AlignToGround()
		end
		self.BaseY = self.Y - 64
		--self.Z = 4001
		self.Width = math.floor(rand()*100)
		self.Height = math.floor(rand()*10)
		self.TweakY = math.floor(rand()*20)
		self.Boredom = 0
		self.Direction = math.floor(rand()+0.5)
		self.LeashLength = self.XMax - self.XMin
		self.XDestination = self.X
		--self.SpeedX = 100
		self.rangeL = self.X
		self.rangeR = self.X
		self.cooldown = 1340
		self.lastAttack = GetTime()
		self.AttackRange = 280--272-- todo change for other types
		if self.SpeedX ~= 0 then
			self.AttackRange = self.SpeedX
		end
		self.LastSeenClawX = nil
		self.AttackObjActive = false
		self.LookAroundsLeft = 3
		self.DrawFlags.NoDraw = true
		local img = "CUSTOM_SENTRY"
		self.Achievements = GetObject(4088)
		self.SentryForceEngine = GetObject(4272)
		self.Flag8 = 1
		if self.Speed == 3 then
			self.Flag8 = 0
		else
			self.Speed = 6
		end
		if self.Achievements.HardMode == true then
			self.Speed = 3
		end
		
		if self.Speed == 3 then
			img = "CUSTOM_SENTRY2"
		end
		self.RutharEye = CreateObject {x=self.X, y=self.BaseY, z=4100, I=1, name="RutharEye", logic="CustomLogic", image=img, SpeedY = self.Y-32, Health = self.Health, UserRect1 = self.UserRect1, UserRect2 = self.UserRect2, Speed = self.Speed, Smarts = self.Smarts}
		if self.Flags.Safe == true then
			self.RutharEye.Flags.Safe = true
		end
		self.sensorL = CreateObject {x=self.X, y=self.BaseY, z=4100, name="DetectorBullet", logic="CustomLogic", image="LEVEL_WOLVINGTONMAGIC", SpeedX = -1}
		self.sensorR = CreateObject {x=self.X, y=self.BaseY, z=4100, name="DetectorBullet", logic="CustomLogic", image="LEVEL_WOLVINGTONMAGIC", SpeedX = 1}
		self.sensorL.DrawFlags.NoDraw = true
		self.sensorR.DrawFlags.NoDraw = true
		self.Flags.AlwaysActive = true
		self.sensorL.Flags.AlwaysActive = true
		self.sensorR.Flags.AlwaysActive = true
		self.sensorLFlag = 0
		self.sensorRFlag = 0
		--GetObject(7098):Destroy()
		self.State = 1
		Look(self)
		self.BoredomTimer = GetTime()
		self.Flag6 = 0
		self.Flag7 = 0
		self.StrengthBurst = 10
	elseif self.State == 1 then
		if self.RutharEye.State == 1 then -- idle
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.RutharEye.I = 1
			if self.BoredomTimer + 500 < GetTime() then
			--if (GetTime() % 100) == 0 then
				self.BoredomTimer = GetTime()
				self.Boredom = self.Boredom - ( math.ceil(rand()*4)*100+10 )
			end
			if self.Boredom <= 0 then
				self.RutharEye.State = 3
			end
		--elseif self.RutharEye.State == 2 then -- taking hit
			--self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			--self.RutharEye.X = self.X
			--self.RutharEye.I = 1
			--if self.RutharEye.TempStunCounter <= GetTime() then
			--	self.RutharEye.State = 1
			--end
			--self.Boredom = 1000
		elseif self.RutharEye.State == 3 then -- wandering decision
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if self.XMin == self.X and self.XMax == self.X then -- static
				SwitchDirection(self)
				self.Boredom = 1000
				self.RutharEye.State = 1
			end
			if self.X < self.XMin + self.LeashLength*0.3 then
				TurnRight(self)
				self.XDestination = self.X + math.floor(math.sqrt(rand())*CalcMaxDistance(self,1))
					
				self.RutharEye.State = 4
			elseif self.X > self.XMax - self.LeashLength*0.3 then
				TurnLeft(self)
				self.XDestination = self.X - math.floor(math.sqrt(rand())*CalcMaxDistance(self,0))
					
				self.RutharEye.State = 4
			else
				if rand() < 0.5 then
					SwitchDirection(self)
				end
				if self.Direction == 0 then
					self.XDestination = self.X - math.floor(math.sqrt(rand())*CalcMaxDistance(self,0))
				else
					self.XDestination = self.X + math.floor(math.sqrt(rand())*CalcMaxDistance(self,1))
				end
				
				self.RutharEye.State = 4
			end
			if getDistanceFromClaw(self)<600 then
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE3MOVE1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE3MOVE2")
				end
			end
		elseif self.RutharEye.State == 4 then -- wandering
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.RutharEye.I = 1
			if self.XDestination == self.X then
				self.Boredom = 1000
				self.RutharEye.State = 1
			end
			if self.XDestination < self.X then
				self.X = self.X - 1
			end
			if self.XDestination > self.X then
				self.X = self.X + 1
			end
		elseif self.RutharEye.State == 6 then -- lost sight of Claw nearby
			if ClawInLOS(self) then
				--self.Boredom = 1000
				self.RutharEye.State = 1
			else
				self.TimeCounter = GetTime()
				self.RutharEye.State = 10
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE3ANNOYED1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE3ANNOYED2")
				end
			end
		elseif self.RutharEye.State == 10 then -- cartoon looking around
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			if ClawInLOS(self) then
				self.RutharEye.State = 1
			elseif self.LookAroundsLeft <= 0 then
				--SwitchDirection(self)
				self.Boredom = 1000
				self.RutharEye.State = 1
			elseif self.TimeCounter + 1000 < GetTime() then
				SwitchDirection(self)
				self.RutharEye.State = 6
				self.LookAroundsLeft = self.LookAroundsLeft - 1
			end
		elseif self.RutharEye.State == 5 then -- Sentry logic
			local claw = GetClaw()
			self.RutharEye.I = 2
			-- is claw still in sight range?
			if ClawInLOS(self) then
				self.LastSeenClawX = claw.X
				self.TimeCounter = GetTime()
				self.RutharEye.State = 7
				self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
				self.RutharEye.X = self.X
			else
				--self.RutharEye.State = 1
				self.LookAroundsLeft = 1
				self.RutharEye.State = 6
			end
			
			--if math.abs(self.X - claw.X) <= 64 then
			
			--end
		elseif self.RutharEye.State == 7 then -- charging attack
			if not isLookingAtClaw(self) then
				SwitchDirection(self)
			end
			Look(self)
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			self.AttackCharge = GetTime()
			if ClawInLOS(self) then
				self.RutharEye.State = 8
			else
				self.LookAroundsLeft = 3
				self.RutharEye.State = 6
			end
			
			
		
		elseif self.RutharEye.State == 8 and self.RutharEye.Health > 0 then -- attack
			self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			self.RutharEye.X = self.X
			local claw = GetClaw()
			--[[
			if self.Force == nil then
				self.Force = CreateObject {x=claw.X, y=claw.Y, z=10000, logic="ConveyorBelt", image="GAME_SOUNDICON", Speed = 0}
				self.Force.DrawFlags.NoDraw = true
				self.Force.MoveRect = {-64,-64,64,64}
			else
				self.Force.Speed = 0
				self.Force.X = claw.X
				self.Force.Y = claw.Y
			end
			if self.Direction == 1 then
				self.Force.Speed = 150 + self.Points
			else
				self.Force.Speed = -150 - self.Points
			end--]]
			if self.SentryForceEngine.sentry_array[self.Counter]["number"] == nil then
				self.SentryForceEngine.sentry_array[self.Counter]["number"] = self.ID
			end
			if self.StrengthBurst > 10 then
				self.StrengthBurst = self.StrengthBurst - 1
			end
			if self.Direction == 1 then
				self.SentryForceEngine.sentry_array[self.Counter]["strength"] = math.floor((150 + self.Points) * self.StrengthBurst / 10)
				--self.Force.Speed = 150 + self.Points
			else
				self.SentryForceEngine.sentry_array[self.Counter]["strength"] = math.floor((-150 - self.Points) * self.StrengthBurst / 10)
				--self.Force.Speed = -150 - self.Points
			end
			
			if claw.State == 5006 then
				ClawJump(20) -- Sentry will attempt to push claw down
			end
			if self.SparkCounter == nil then
				self.SparkCounter = GetTime()
			else
				if self.SparkCounter + 75 <= GetTime() then
					local r = rand()
					if self.Speed == 3 then
						local dd = 1-((GetTime() - self.AttackCharge)/1500)
						CreateObject {x=claw.X + (self.RutharEye.X-claw.X)*r, y=claw.Y + (self.RutharEye.Y-claw.Y)*r, z=9000, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLERED"}
						CreateObject {x=claw.X + (self.RutharEye.X-claw.X)*dd, y=claw.Y + (self.RutharEye.Y-claw.Y)*dd, z=9000, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLERED"}
						CreateObject {x=claw.X + (self.RutharEye.X-claw.X)*dd +12*r-6, y=claw.Y + (self.RutharEye.Y-claw.Y)*dd +12*r-6, z=9000, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLERED"}
					else
						CreateObject {x=claw.X + (self.RutharEye.X-claw.X)*r, y=claw.Y + (self.RutharEye.Y-claw.Y)*r, z=9000, name="Spark", logic="CustomLogic", image="GAME_SPARKLE"}
					end
					if GetTime() >= self.AttackCharge + 1500 and claw.Health > 0 and self.Speed == 3 then
						self.AttackCharge = GetTime()
						ClawTakeDamage(20)
						GetClaw().Height = 23
						CreateObject {x=claw.X, y=claw.Y, z=9000, name="ClawHit", logic="CustomLogic", image="GAME_CLAWHIT"}
						self.StrengthBurst = 60
					end
					self.SparkCounter = GetTime()
				end
			end
			
			self.AttackObjActive = true
			self.lastAttack = GetTime()
			--self.TimeCounter = GetTime()
			--self.RutharEye.State = 9
			if not ClawInLOS(self) then
				self.SentryForceEngine.sentry_array[self.Counter]["strength"] = nil
				--self.Force.Speed = 0
				self.RutharEye.State = 1
				self.BoredomTimer = 1000
				self.AttackCharge = GetTime()
			end
		--elseif self.RutharEye.State == 9 then -- after attack
			--self.RutharEye.Y = self.BaseY + getFloatingYModifier(self)
			--self.RutharEye.X = self.X
			--self.AttackProjectile.Y = self.RutharEye.Y
			--self.RutharEye.State = 1
		elseif self.RutharEye.State == 11 then -- getting hit
			if not isLookingAtClaw(self) then
				self.Achievements.BackStabs = self.Achievements.BackStabs + 1
				SwitchDirection(self)
			end
			if ClawInLOS(self) then
				self.RutharEye.State = 1
			else
				self.RutharEye.I = 2
				self.LookAroundsLeft = 3
				self.RutharEye.State = 6
			end
		end
		if self.RutharEye.State == 1 or self.RutharEye.State == 4 then -- do spotting
			if ClawInLOS(self) then
				self.RutharEye.State = 5
				if not isLookingAtClaw(self) then
					SwitchDirection(self)
				end
				if rand() > 0.5 then
					PlaySound("CUSTOM_TRIGGER_EYE3ANGRY1")
				else
					PlaySound("CUSTOM_TRIGGER_EYE3ANGRY2")
				end
				--TextOut(self.RutharEye.State)
			end
		end
		--TextOut(self.RutharEye.State .. ", " .. self.Boredom .. ", " .. self.XDestination)
	end
	if self.sensorLFlag == 0 then
		if self.sensorL.Collision == 1 then
			self.rangeL = self.sensorL.CollisionX
			self.sensorLFlag = 1
			self.sensorL:Destroy()
		end
	end
	if self.sensorRFlag == 0 then
		if self.sensorR.Collision == 1 then
			self.rangeR = self.sensorR.CollisionX
			self.sensorRFlag = 1
			self.sensorR:Destroy()
		end
	end
	if self.sensorLFlag == 1 and self.sensorRFlag == 1 then
		self.Flags.AlwaysActive = false
		--TextOut(self.rangeL .. ", " .. self.rangeR)
	end
	local claw = GetClaw()
	--if claw.Y > self.RutharEye.Y - 12 and claw.Y < self.RutharEye.Y - 24
	--TextOut(self.RutharEye.State)
	--TextOut(claw.Z)
	
	if self.RutharEye.Health <= 0 then
		if self.Flag6 == 0 then
			self.Flag6 = 1
			self.Achievements.ReKills = self.Achievements.ReKills + 1
		end
		if self.Speed == 3 and self.Flag8 == 0 then
			self.Flag8 = 1
			self.Achievements.MutantKills = self.Achievements.MutantKills + 1
		end
		
		--TextOut(self.RutharEye.Y)
		self.rcore = CreateObject {x=self.REX, y=self.REY, z=3900, name="RutharCore", logic="CustomLogic", image="CUSTOM_RUTHARCOREGREEN", SpeedY = self.Y-32, UserRect1 = self.UserRect1, UserRect2 = self.UserRect2, Powerup = self.Powerup}
		CreateObject {x=self.REX, y=self.REY, z=3950, name="Explosion", logic="CustomLogic", image="CUSTOM_EXPLOSION"}
		PlaySound("CUSTOM_TRIGGER_BURNING1")
		if self.Smarts == 1 then
			self.rcore.Flags.AlwaysActive = true
			if self.Flag7 == 0 then
				self.Flag7 = 1
				self.Achievements.ShootKills = self.Achievements.ShootKills + 1
			end
		end
		
		local cm = GetObject(4219)
		if cm.UnnaturalHunger == true then
			local claw = GetClaw()
			if claw.Health > 0 then
				claw.Health = claw.Health + 5
				cm.lastHP = claw.Health
			end
		end
		
		self.RutharEye.State = 2
		self.RutharEye.DrawFlags.NoDraw = true
		self.SentryForceEngine.sentry_array[self.Counter]["strength"] = nil
		if self.rcore.Y > 0 then
			self.RutharEye:Destroy()
			self.RutharEye = nil
			self:Destroy()
		end
	end
	
	if self.RutharEye ~= nil then
		if self.RutharEye.Y > 0 and self.RutharEye.Y < 12000 then
			self.REX = self.RutharEye.X
			self.REY = self.RutharEye.Y
		end
	end
end